﻿import viz
import vizconnect
import vizact
import vizproximity

vizconnect.go('vizconnect_config_desktop.py')
dojo = viz.addChild('dojo.osgb')

#Create proximity manager
manager = vizproximity.Manager()
manager.setDebug(viz.ON)

avatar = vizconnect.getAvatar()
hands = avatar.getHands()
rightHand = hands[vizconnect.AVATAR_R_HAND]
target = viz.addGroup()
manager.addTarget(target)

def updateTarget():
	pos = rightHand.getPosition(viz.ABS_GLOBAL)
	target.setPosition(pos)
vizact.ontimer(0,updateTarget)

#Create sensor using male avatar
avatar = viz.addAvatar('vcc_male2.cfg',pos=[0,0,4],euler=[180,0,0])
avatar.state(1)
sensor = vizproximity.addBoundingSphereSensor(avatar,scale=2)
manager.addSensor(sensor)

#Change state of avatar to talking when the user gets near
def EnterProximity(e):
    avatar.state(4)

#Change state of avatar to idle when the user moves away
def ExitProximity(e):
    avatar.state(1)

manager.onEnter(sensor,EnterProximity)
manager.onExit(sensor,ExitProximity)

vizact.onkeydown('d',manager.setDebug,viz.TOGGLE) 